/*
 * Decompiled with CFR 0.152.
 */
package cofh.repack.codechicken.lib.vec;

import cofh.repack.codechicken.lib.util.Copyable;
import cofh.repack.codechicken.lib.vec.Transformation;
import cofh.repack.codechicken.lib.vec.Vector3;
import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;
import net.minecraft.block.Block;
import net.minecraft.util.AxisAlignedBB;

public class Cuboid6
implements Copyable<Cuboid6> {
    public static Cuboid6 full = new Cuboid6(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
    public Vector3 min;
    public Vector3 max;

    public Cuboid6(Vector3 vector3, Vector3 vector32) {
        this.min = vector3;
        this.max = vector32;
    }

    public Cuboid6(AxisAlignedBB axisAlignedBB) {
        this.min = new Vector3(axisAlignedBB.minX, axisAlignedBB.minY, axisAlignedBB.minZ);
        this.max = new Vector3(axisAlignedBB.maxX, axisAlignedBB.maxY, axisAlignedBB.maxZ);
    }

    public Cuboid6(Cuboid6 cuboid6) {
        this.min = cuboid6.min.copy();
        this.max = cuboid6.max.copy();
    }

    public Cuboid6(double d, double d2, double d3, double d4, double d5, double d6) {
        this.min = new Vector3(d, d2, d3);
        this.max = new Vector3(d4, d5, d6);
    }

    public AxisAlignedBB toAABB() {
        return AxisAlignedBB.getBoundingBox((double)this.min.x, (double)this.min.y, (double)this.min.z, (double)this.max.x, (double)this.max.y, (double)this.max.z);
    }

    @Override
    public Cuboid6 copy() {
        return new Cuboid6(this);
    }

    public Cuboid6 set(Cuboid6 cuboid6) {
        return this.set(cuboid6.min, cuboid6.max);
    }

    public Cuboid6 set(Vector3 vector3, Vector3 vector32) {
        this.min.set(vector3);
        this.max.set(vector32);
        return this;
    }

    public Cuboid6 set(double d, double d2, double d3, double d4, double d5, double d6) {
        this.min.set(d, d2, d3);
        this.max.set(d4, d5, d6);
        return this;
    }

    public Cuboid6 add(Vector3 vector3) {
        this.min.add(vector3);
        this.max.add(vector3);
        return this;
    }

    public Cuboid6 sub(Vector3 vector3) {
        this.min.subtract(vector3);
        this.max.subtract(vector3);
        return this;
    }

    public Cuboid6 expand(double d) {
        return this.expand(new Vector3(d, d, d));
    }

    public Cuboid6 expand(Vector3 vector3) {
        this.min.sub(vector3);
        this.max.add(vector3);
        return this;
    }

    public void setBlockBounds(Block block) {
        block.setBlockBounds((float)this.min.x, (float)this.min.y, (float)this.min.z, (float)this.max.x, (float)this.max.y, (float)this.max.z);
    }

    public boolean intersects(Cuboid6 cuboid6) {
        return this.max.x - 1.0E-5 > cuboid6.min.x && cuboid6.max.x - 1.0E-5 > this.min.x && this.max.y - 1.0E-5 > cuboid6.min.y && cuboid6.max.y - 1.0E-5 > this.min.y && this.max.z - 1.0E-5 > cuboid6.min.z && cuboid6.max.z - 1.0E-5 > this.min.z;
    }

    public Cuboid6 offset(Cuboid6 cuboid6) {
        this.min.add(cuboid6.min);
        this.max.add(cuboid6.max);
        return this;
    }

    public Vector3 center() {
        return this.min.copy().add(this.max).multiply(0.5);
    }

    public static boolean intersects(Cuboid6 cuboid6, Cuboid6 cuboid62) {
        return cuboid6 != null && cuboid62 != null && cuboid6.intersects(cuboid62);
    }

    public String toString() {
        MathContext mathContext = new MathContext(4, RoundingMode.HALF_UP);
        return "Cuboid: (" + new BigDecimal(this.min.x, mathContext) + ", " + new BigDecimal(this.min.y, mathContext) + ", " + new BigDecimal(this.min.z, mathContext) + ") -> (" + new BigDecimal(this.max.x, mathContext) + ", " + new BigDecimal(this.max.y, mathContext) + ", " + new BigDecimal(this.max.z, mathContext) + ")";
    }

    public Cuboid6 enclose(Vector3 vector3) {
        if (this.min.x > vector3.x) {
            this.min.x = vector3.x;
        }
        if (this.min.y > vector3.y) {
            this.min.y = vector3.y;
        }
        if (this.min.z > vector3.z) {
            this.min.z = vector3.z;
        }
        if (this.max.x < vector3.x) {
            this.max.x = vector3.x;
        }
        if (this.max.y < vector3.y) {
            this.max.y = vector3.y;
        }
        if (this.max.z < vector3.z) {
            this.max.z = vector3.z;
        }
        return this;
    }

    public Cuboid6 enclose(Cuboid6 cuboid6) {
        if (this.min.x > cuboid6.min.x) {
            this.min.x = cuboid6.min.x;
        }
        if (this.min.y > cuboid6.min.y) {
            this.min.y = cuboid6.min.y;
        }
        if (this.min.z > cuboid6.min.z) {
            this.min.z = cuboid6.min.z;
        }
        if (this.max.x < cuboid6.max.x) {
            this.max.x = cuboid6.max.x;
        }
        if (this.max.y < cuboid6.max.y) {
            this.max.y = cuboid6.max.y;
        }
        if (this.max.z < cuboid6.max.z) {
            this.max.z = cuboid6.max.z;
        }
        return this;
    }

    public Cuboid6 apply(Transformation transformation) {
        double d;
        transformation.apply(this.min);
        transformation.apply(this.max);
        if (this.min.x > this.max.x) {
            d = this.min.x;
            this.min.x = this.max.x;
            this.max.x = d;
        }
        if (this.min.y > this.max.y) {
            d = this.min.y;
            this.min.y = this.max.y;
            this.max.y = d;
        }
        if (this.min.z > this.max.z) {
            d = this.min.z;
            this.min.z = this.max.z;
            this.max.z = d;
        }
        return this;
    }

    public double getSide(int n) {
        switch (n) {
            case 0: {
                return this.min.y;
            }
            case 1: {
                return this.max.y;
            }
            case 2: {
                return this.min.z;
            }
            case 3: {
                return this.max.z;
            }
            case 4: {
                return this.min.x;
            }
            case 5: {
                return this.max.x;
            }
        }
        throw new IndexOutOfBoundsException("Switch Falloff");
    }

    public Cuboid6 setSide(int n, double d) {
        switch (n) {
            case 0: {
                this.min.y = d;
                break;
            }
            case 1: {
                this.max.y = d;
                break;
            }
            case 2: {
                this.min.z = d;
                break;
            }
            case 3: {
                this.max.z = d;
                break;
            }
            case 4: {
                this.min.x = d;
                break;
            }
            case 5: {
                this.max.x = d;
                break;
            }
            default: {
                throw new IndexOutOfBoundsException("Switch Falloff");
            }
        }
        return this;
    }
}

